/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.HugeDieselEngineBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.Couple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PoweredEngineShaftBlockEntity
extends GeneratingKineticBlockEntity {
    float stressCapacity;
    float speed;
    int movementDirection = 0;
    int initialTicks;
    public Map<class_2338, Couple<Float>> engines = new HashMap<class_2338, Couple<Float>>();

    public PoweredEngineShaftBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    public boolean isEngineForConnectorDisplay(class_2338 pos) {
        class_2350.class_2351 axis = (class_2350.class_2351)this.method_11010().method_11654((class_2769)RotatedPillarKineticBlock.AXIS);
        for (class_2350 d : List.of(axis == class_2350.class_2351.field_11051 ? class_2350.field_11036 : class_2350.field_11043, axis == class_2350.class_2351.field_11051 ? class_2350.field_11033 : class_2350.field_11035, axis == class_2350.class_2351.field_11048 ? class_2350.field_11036 : class_2350.field_11034, axis == class_2350.class_2351.field_11048 ? class_2350.field_11033 : class_2350.field_11039)) {
            class_2680 st = this.method_10997().method_8320(this.method_11016().method_10079(d, 2));
            if (!(st.method_26204() instanceof HugeDieselEngineBlock) || st.method_11654((class_2769)HugeDieselEngineBlock.FACING) != d.method_10153()) continue;
            return this.method_11016().method_10079(d, 2).equals((Object)pos);
        }
        return false;
    }

    public void update(class_2338 sourcePos, int direction, float stress, float speed) {
        if (this.engines.containsKey(sourcePos)) {
            this.engines.replace(sourcePos, (Couple<Float>)Couple.create((Object)Float.valueOf(stress), (Object)Float.valueOf(speed)));
        } else {
            this.engines.put(sourcePos, (Couple<Float>)Couple.create((Object)Float.valueOf(stress), (Object)Float.valueOf(speed)));
        }
        AtomicReference<Float> maxSpeed = new AtomicReference<Float>(Float.valueOf(0.0f));
        Map<class_2338, Couple<Float>> map = Map.copyOf(this.engines);
        for (Couple<Float> s : map.values()) {
            if (!(((Float)s.getSecond()).floatValue() > maxSpeed.get().floatValue())) continue;
            maxSpeed.set((Float)s.getSecond());
        }
        this.speed = maxSpeed.get().floatValue();
        this.movementDirection = direction;
        this.reActivateSource = true;
    }

    public boolean canBePoweredBy(class_2338 globalPos) {
        return this.initialTicks == 0;
    }

    public void removeGenerator(class_2338 sourcePos) {
        this.engines.remove(sourcePos);
        if (this.engines.isEmpty()) {
            this.movementDirection = 0;
            this.speed = 0.0f;
            this.stressCapacity = 0.0f;
        }
        this.reActivateSource = true;
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.method_10569("Warmup", this.initialTicks);
        }
        class_2499 engineList = new class_2499();
        Map<class_2338, Couple<Float>> map = Map.copyOf(this.engines);
        map.forEach((p, s) -> {
            class_2487 tag = new class_2487();
            tag.method_10548("Capacity", ((Float)s.getFirst()).floatValue());
            tag.method_10548("Speed", ((Float)s.getSecond()).floatValue());
            tag.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)p));
            engineList.add((Object)tag);
        });
        compound.method_10548("GeneratedSpeed", this.speed);
        compound.method_10566("Engines", (class_2520)engineList);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.movementDirection = compound.method_10550("Direction");
        this.initialTicks = compound.method_10550("Warmup");
        class_2499 engineList = compound.method_10554("Engines", 10);
        HashMap<class_2338, Couple<Float>> map = new HashMap<class_2338, Couple<Float>>();
        for (int i = 0; i < engineList.size(); ++i) {
            map.put(class_2512.method_10691((class_2487)engineList.method_10602(i).method_10562("Pos")), (Couple<Float>)Couple.create((Object)Float.valueOf(engineList.method_10602(i).method_10583("Capacity")), (Object)Float.valueOf(engineList.method_10602(i).method_10583("Speed"))));
        }
        this.engines.clear();
        this.engines = map;
        this.speed = compound.method_10583("GeneratedSpeed");
    }

    public float getGeneratedSpeed() {
        return (float)this.movementDirection * this.speed;
    }

    public float calculateAddedStressCapacity() {
        if (this.movementDirection == 0) {
            return 0.0f;
        }
        AtomicReference<Float> stress = new AtomicReference<Float>(Float.valueOf(0.0f));
        Map<class_2338, Couple<Float>> map = Map.copyOf(this.engines);
        map.forEach((b, s) -> stress.updateAndGet(f -> Float.valueOf(f.floatValue() + ((Float)s.getFirst()).floatValue() / ((Float)s.getSecond()).floatValue())));
        this.lastCapacityProvided = this.capacity;
        return stress.get().floatValue();
    }

    public int getRotationAngleOffset(class_2350.class_2351 axis) {
        int combinedCoords = axis.method_10173(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }
}

